/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.remconsq;

import com.ibm.hwmca.base.remconsq.CommPathInfo;
import com.ibm.hwmca.base.remconsq.RemoteConnectionServicesBean;
import com.ibm.hwmca.base.remconsq.RemoteConnectionServicesConstants;
import com.ibm.hwmca.base.remconsq.RemoteConnectionServicesErrorIds;
import com.ibm.hwmca.fw.connserv.CommPath;
import com.ibm.hwmca.fw.connserv.CommPathManager;
import com.ibm.hwmca.fw.connserv.PathQueueListener;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

public class RemoteConnectionServicesTasklet
extends PanelTasklet
implements PathQueueListener,
RemoteConnectionServicesConstants,
RemoteConnectionServicesErrorIds {
    private static final String TRACEMASK_T = "XRQDTLTT";
    private static final String TRACEMASK_F = "XRQDTLTF";
    private static final String TRACEMASK_D = "XRQDTLTD";
    private static final String AUIML_PATH = "com.ibm.hwmca.base.remconsq.res.RemoteConnectionServicesRes";
    private static final String AUIML_PANELNAME = "RemoteConnectionServicesPanel";
    private FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "RCSTasklet");
    private static List pendingUpdatesQueue;

    public RemoteConnectionServicesTasklet() {
        pendingUpdatesQueue = new ArrayList();
    }

    public void destroy() {
        Trace.trace(TRACEMASK_T, "<--> destroy()");
        CommPathManager.getCommPathManager().removeQueueListener(this);
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACEMASK_T, "--> logException(" + throwable + ")");
        new FrameworkLog(this.logInfo, 1, throwable).log();
        Trace.trace(TRACEMASK_T, "<-- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block26: {
            Trace.trace(TRACEMASK_T, "--> service(" + request + ", " + response + ")");
            CommPathManager commPathManager = CommPathManager.getCommPathManager();
            try {
                if (request.isInitialRequest()) {
                    RemoteConnectionServicesBean bean = new RemoteConnectionServicesBean();
                    bean.setBeanName("ServicesPanelBean");
                    bean.setQueueStatusOutput(commPathManager.isProcessingEnabled() ? RemoteConnectionServicesConstants.Q_ACTIVE : RemoteConnectionServicesConstants.Q_HOLDING);
                    bean.setRemoteConSrvOutput(commPathManager.isRCSOutboundEnabled() ? RemoteConnectionServicesConstants.RCS_ENABLED : RemoteConnectionServicesConstants.RCS_DISABLED);
                    RemoteConnectionServicesTasklet remoteConnectionServicesTasklet = this;
                    synchronized (remoteConnectionServicesTasklet) {
                        bean.setQueues(this.extractCommPathInfo(commPathManager.getQueuedPaths(this)));
                    }
                    response.replace(AUIML_PATH, AUIML_PANELNAME, bean);
                    break block26;
                }
                if (request.isDisposed() || request.isCanceled()) {
                    response.terminate();
                    break block26;
                }
                String source = (String)request.getSource();
                Trace.trace(TRACEMASK_F, "source of request = \"" + source + "\"");
                if (source.equals("ServicesPanelBean")) {
                    int[] commPathIDs = null;
                    CommPath commPath = null;
                    String command = (String)request.getData("command");
                    Trace.trace(TRACEMASK_F, "command from panel = \"" + command + "\"");
                    if (command.equals("PrioritizeItem")) {
                        commPathIDs = (int[])request.getData("commpathids");
                        int i = commPathIDs.length - 1;
                        while (i >= 0) {
                            commPath = commPathManager.getPathById(commPathIDs[i]);
                            if (commPath != null) {
                                try {
                                    commPathManager.prioritizeCommPath(commPath);
                                }
                                catch (IllegalStateException isEx) {
                                    Trace.trace(TRACEMASK_T, "CommPathManager.prioritizeCommPath() threw exception: " + isEx);
                                }
                            }
                            --i;
                        }
                        response.noAction();
                        break block26;
                    }
                    if (command.equals("CancelSelectedItem")) {
                        commPathIDs = (int[])request.getData("commpathids");
                        int i = 0;
                        while (i < commPathIDs.length) {
                            commPath = commPathManager.getPathById(commPathIDs[i]);
                            if (commPath != null) {
                                try {
                                    commPath.cancel(1);
                                }
                                catch (IllegalStateException isEx) {
                                    Trace.trace(TRACEMASK_T, "CommPath.cancel() threw exception: " + isEx);
                                }
                            }
                            ++i;
                        }
                        response.noAction();
                        break block26;
                    }
                    if (command.equals("HoldTheQueueItem")) {
                        commPathManager.setProcessingEnabled(false);
                        response.noAction();
                    } else if (command.equals("ReleaseTheQueueItem")) {
                        commPathManager.setProcessingEnabled(true);
                        response.noAction();
                    } else {
                        response.noAction();
                    }
                    break block26;
                }
                if (source.equals("RCSTasklet")) {
                    List commPathIDs = pendingUpdatesQueue;
                    synchronized (commPathIDs) {
                        response.update("ServicesPanelBean", pendingUpdatesQueue);
                        pendingUpdatesQueue = new ArrayList();
                        break block26;
                    }
                }
                response.noAction();
            }
            catch (Exception ex) {
                Trace.trace(TRACEMASK_T, "Exception in service()!  Error logged!");
                TaskletException tex = new TaskletException(ex);
                new FrameworkLog(this.logInfo, 3, tex).log();
                throw tex;
            }
        }
        Trace.trace(TRACEMASK_T, "<-- service()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedToWaiting(CommPath commPath, int position) {
        Trace.trace(TRACEMASK_T, "--> addedToWaiting(" + commPath + ", " + position + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest request = null;
        try {
            map = new HashMap<String, Object>(3);
            map.put("updateType", "addedToWaiting");
            map.put("commPathObject", new CommPathInfo(commPath));
            map.put("commPathPosition", new Integer(position));
            List list = pendingUpdatesQueue;
            synchronized (list) {
                pendingUpdatesQueue.add(map);
                if (pendingUpdatesQueue.size() == 1) {
                    request = new PanelTaskletRequest();
                    request.setSource("RCSTasklet");
                    this.postRequest("ServicesPanelBean", request);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in addedToWaiting()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- addedToWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromWaitingToActive(CommPath commPath) {
        Trace.trace(TRACEMASK_T, "--> moveFromWaitingToActive(" + commPath + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest request = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "movedFromWaitingToActive");
            map.put("commPathObject", new CommPathInfo(commPath));
            List list = pendingUpdatesQueue;
            synchronized (list) {
                pendingUpdatesQueue.add(map);
                if (pendingUpdatesQueue.size() == 1) {
                    request = new PanelTaskletRequest();
                    request.setSource("RCSTasklet");
                    this.postRequest("ServicesPanelBean", request);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in movedFromWaitingToActive()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- moveFromWaitingToActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromActive(CommPath commPath) {
        Trace.trace(TRACEMASK_T, "--> removedFromActive(" + commPath + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest request = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "removedFromActive");
            map.put("commPathObject", new CommPathInfo(commPath));
            List list = pendingUpdatesQueue;
            synchronized (list) {
                pendingUpdatesQueue.add(map);
                if (pendingUpdatesQueue.size() == 1) {
                    request = new PanelTaskletRequest();
                    request.setSource("RCSTasklet");
                    this.postRequest("ServicesPanelBean", request);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in removedFromActive()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- removedFromActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromWaiting(CommPath commPath) {
        Trace.trace(TRACEMASK_T, "--> removedFromWaiting(" + commPath + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest request = null;
        try {
            map = new HashMap<String, Object>(2);
            map.put("updateType", "removedFromWaiting");
            map.put("commPathObject", new CommPathInfo(commPath));
            List list = pendingUpdatesQueue;
            synchronized (list) {
                pendingUpdatesQueue.add(map);
                if (pendingUpdatesQueue.size() == 1) {
                    request = new PanelTaskletRequest();
                    request.setSource("RCSTasklet");
                    this.postRequest("ServicesPanelBean", request);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in removedFromWaiting()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- removedFromWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderInWaiting(CommPath commPath, int newPosition) {
        Trace.trace(TRACEMASK_T, "--> reorderInWaiting(" + commPath + ", " + newPosition + ")");
        HashMap<String, Object> map = null;
        PanelTaskletRequest request = null;
        try {
            map = new HashMap<String, Object>(3);
            map.put("updateType", "reorderInWaiting");
            map.put("commPathObject", new CommPathInfo(commPath));
            map.put("commPathPosition", new Integer(newPosition));
            List list = pendingUpdatesQueue;
            synchronized (list) {
                pendingUpdatesQueue.add(map);
                if (pendingUpdatesQueue.size() == 1) {
                    request = new PanelTaskletRequest();
                    request.setSource("RCSTasklet");
                    this.postRequest("ServicesPanelBean", request);
                }
            }
        }
        catch (TaskletException tex) {
            Trace.trace(TRACEMASK_T, "Exception in reorderInWaiting()!  Error logged!");
            new FrameworkLog(this.logInfo, 2, tex).log();
        }
        Trace.trace(TRACEMASK_T, "<-- reorderInWaiting()");
    }

    private List[] extractCommPathInfo(List[] commPaths) {
        Trace.trace(TRACEMASK_T, "-> extractCommPathInfo(" + commPaths + ")");
        ArrayList<CommPathInfo> activeQueue = new ArrayList<CommPathInfo>(commPaths[0].size());
        ArrayList<CommPathInfo> waitingQueue = new ArrayList<CommPathInfo>(commPaths[1].size());
        List[] queues = new List[]{activeQueue, waitingQueue};
        ListIterator iterator = null;
        try {
            iterator = commPaths[0].listIterator();
            while (iterator.hasNext()) {
                activeQueue.add(new CommPathInfo((CommPath)iterator.next()));
            }
            iterator = commPaths[1].listIterator();
            while (iterator.hasNext()) {
                waitingQueue.add(new CommPathInfo((CommPath)iterator.next()));
            }
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception in extractCommPathInfo()!  Error logged!");
            new FrameworkLog(this.logInfo, 1, ex).log();
        }
        Trace.trace(TRACEMASK_T, "<- extractCommPathInfo() (return: " + queues + ")");
        return queues;
    }
}

